<?php
$masonry_classes = '';
$number_of_columns = onschedule_edge_get_meta_field_intersect('portfolio_single_masonry_columns_number');
if(!empty($number_of_columns)) {
	$masonry_classes .= ' edgtf-ps-'.$number_of_columns.'-columns';
}
$space_between_items = onschedule_edge_get_meta_field_intersect('portfolio_single_masonry_space_between_items');
if(!empty($space_between_items)) {
	$masonry_classes .= ' edgtf-ps-'.$space_between_items.'-space';
}
?>
<div class="edgtf-columns-wrapper edgtf-content-columns-66-33 edgtf-content-sidebar-right edgtf-content-has-sidebar edgtf-columns-normal-space">
	<div class="edgtf-columns-inner">
		<div class="edgtf-column-content edgtf-column-content1">
			<div class="edgtf-ps-image-holder edgtf-ps-masonry-images <?php echo esc_attr($masonry_classes); ?>">
				<div class="edgtf-ps-image-inner">
					<div class="edgtf-ps-grid-sizer"></div>
					<div class="edgtf-ps-grid-gutter"></div>
					<?php
					$media = onschedule_edge_get_portfolio_single_media();
					
					if(is_array($media) && count($media)) : ?>
						<?php foreach($media as $single_media) : ?>
							<div class="edgtf-ps-image <?php echo esc_attr($single_media['holder_classes']); ?>">
								<?php onschedule_edge_portfolio_get_media_html($single_media); ?>
							</div>
						<?php endforeach; ?>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<div class="edgtf-column-content edgtf-column-content2">
			<div class="edgtf-ps-info-holder edgtf-ps-info-sticky-holder">
				<?php
				//get portfolio content section
				onschedule_edge_get_module_template_part('templates/single/parts/content', 'portfolio', $item_layout);
				
				//get portfolio custom fields section
				onschedule_edge_get_module_template_part('templates/single/parts/custom-fields', 'portfolio', $item_layout);
				
				//get portfolio categories section
				onschedule_edge_get_module_template_part('templates/single/parts/categories', 'portfolio', $item_layout);
				
				//get portfolio date section
				onschedule_edge_get_module_template_part('templates/single/parts/date', 'portfolio', $item_layout);
				
				//get portfolio tags section
				onschedule_edge_get_module_template_part('templates/single/parts/tags', 'portfolio', $item_layout);
				
				//get portfolio share section
				onschedule_edge_get_module_template_part('templates/single/parts/social', 'portfolio', $item_layout);
				?>
			</div>
		</div>
	</div>
</div>