<?php

if(!function_exists('onschedule_edge_register_required_plugins')) {
    /**
     * Registers Visual Composer, Revolution Slider, Edge Core, Edge Restaurant, Edge Instagram Feed, Edgef Twitter Feed  as required plugins. Hooks to tgmpa_register hook
     */
    function onschedule_edge_register_required_plugins() {
        $plugins = array(
            array(
                'name'               => esc_html__('WPBakery Page Builder', 'onschedule'),
                'slug'               => 'js_composer',
                'source'             => get_template_directory().'/includes/plugins/js_composer.zip',
                'required'           => true,
                'version'            => '5.4.5',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
            array(
                'name'               => esc_html__('Revolution Slider', 'onschedule'),
                'slug'               => 'revslider',
                'source'             => get_template_directory().'/includes/plugins/revslider.zip',
                'version'            => '5.4.6.4',
                'required'           => true,
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
	        array(
		        'name'               => esc_html__('Booked', 'onschedule'),
		        'slug'               => 'booked',
		        'source'             => get_template_directory().'/includes/plugins/booked.zip',
		        'version'            => '2.0.7',
		        'required'           => true,
		        'force_activation'   => false,
		        'force_deactivation' => false,
		        'external_url'       => ''
	        ),
	        array(
		        'name'               => esc_html__('Booked Calendar Feeds', 'onschedule'),
		        'slug'               => 'booked-calendar-feeds',
		        'source'             => get_template_directory().'/includes/plugins/booked-calendar-feeds.zip',
		        'version'            => '1.1.5',
		        'required'           => false,
		        'force_activation'   => false,
		        'force_deactivation' => false,
		        'external_url'       => ''
	        ),
	        array(
		        'name'               => esc_html__('Booked Frontend Agents', 'onschedule'),
		        'slug'               => 'booked-frontend-agents',
		        'source'             => get_template_directory().'/includes/plugins/booked-frontend-agents.zip',
		        'version'            => '1.1.15',
		        'required'           => false,
		        'force_activation'   => false,
		        'force_deactivation' => false,
		        'external_url'       => ''
	        ),
	        array(
		        'name'               => esc_html__('Booked WooCommerce Payments', 'onschedule'),
		        'slug'               => 'booked-woocommerce-payments',
		        'source'             => get_template_directory().'/includes/plugins/booked-woocommerce-payments.zip',
		        'version'            => '1.4.7',
		        'required'           => false,
		        'force_activation'   => false,
		        'force_deactivation' => false,
		        'external_url'       => ''
	        ),
            array(
                'name'               => esc_html__('Edge Core', 'onschedule'),
                'slug'               => 'edgtf-core',
                'source'             => get_template_directory().'/includes/plugins/edgtf-core.zip',
                'required'           => true,
                'version'            => '1.0.1',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
	        array(
		        'name'               => esc_html__('Edge Restaurant', 'onschedule'),
		        'slug'               => 'edgtf-restaurant',
		        'source'             => get_template_directory().'/includes/plugins/edgtf-restaurant.zip',
		        'required'           => true,
		        'version'            => '1.0',
		        'force_activation'   => false,
		        'force_deactivation' => false,
		        'external_url'       => ''
	        ),
            array(
                'name'               => esc_html__('Edge Instagram Feed', 'onschedule'),
                'slug'               => 'edgtf-instagram-feed',
                'source'             => get_template_directory().'/includes/plugins/edgtf-instagram-feed.zip',
                'required'           => true,
                'version'            => '1.0',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
            array(
                'name'               => esc_html__('Edge Twitter Feed', 'onschedule'),
                'slug'               => 'edgtf-twitter-feed',
                'source'             => get_template_directory().'/includes/plugins/edgtf-twitter-feed.zip',
                'required'           => true,
                'version'            => '1.0',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
            array(
                'name'               => esc_html__('Envato Market', 'onschedule'),
                'slug'               => 'envato-market',
                'source'             => get_template_directory().'/includes/plugins/envato-market.zip',
                'required'           => true,
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
            array(
                'name'               => esc_html__( 'WooCommerce', 'onschedule' ),
                'slug'               => 'woocommerce',
                'external_url'       => 'https://wordpress.org/plugins/woocommerce/',
                'required'           => false
            ),
            array(
                'name'               => esc_html__( 'Contact Form 7', 'onschedule' ),
                'slug'               => 'contact-form-7',
                'external_url'       => 'https://wordpress.org/plugins/contact-form-7/',
                'required'           => false
            )
        );

        $config = array(
            'domain'           => 'onschedule',
            'default_path'     => '',
            'parent_slug' 	   => 'themes.php',
            'capability' 	   => 'edit_theme_options',
            'menu'             => 'install-required-plugins',
            'has_notices'      => true,
            'is_automatic'     => false,
            'message'          => '',
            'strings'          => array(
                'page_title'                      => esc_html__('Install Required Plugins', 'onschedule'),
                'menu_title'                      => esc_html__('Install Plugins', 'onschedule'),
                'installing'                      => esc_html__('Installing Plugin: %s', 'onschedule'),
                'oops'                            => esc_html__('Something went wrong with the plugin API.', 'onschedule'),
                'notice_can_install_required'     => _n_noop('This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'onschedule'),
                'notice_can_install_recommended'  => _n_noop('This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'onschedule'),
                'notice_cannot_install'           => _n_noop('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'onschedule'),
                'notice_can_activate_required'    => _n_noop('The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'onschedule'),
                'notice_can_activate_recommended' => _n_noop('The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'onschedule'),
                'notice_cannot_activate'          => _n_noop('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'onschedule'),
                'notice_ask_to_update'            => _n_noop('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'onschedule'),
                'notice_cannot_update'            => _n_noop('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'onschedule'),
                'install_link'                    => _n_noop('Begin installing plugin', 'Begin installing plugins', 'onschedule'),
                'activate_link'                   => _n_noop('Activate installed plugin', 'Activate installed plugins', 'onschedule'),
                'return'                          => esc_html__('Return to Required Plugins Installer', 'onschedule'),
                'plugin_activated'                => esc_html__('Plugin activated successfully.', 'onschedule'),
                'complete'                        => esc_html__('All plugins installed and activated successfully. %s', 'onschedule'),
                'nag_type'                        => 'updated'
            )
        );

        tgmpa($plugins, $config);
    }

    add_action('tgmpa_register', 'onschedule_edge_register_required_plugins');
}